<?php

namespace  App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Utilisateur extends Model 
{

    protected $table = 'utilisateur';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function roles()
    {
        return $this->belongsToMany(' App\Models\Role');
    }

    public function entreprise()
    {
        return $this->hasMany('App\Models\Entreprise');
    }

    public function hierachie()
    {
        return $this->belongsTo(' App\Models\Hierachie', 'hierachie_id');
    }

    public function courrier()
    {
        return $this->belongsToMany(' App\Models\Courrier');
    }

    public function poste()
    {
        return $this->belongsTo('App\Models\Fonction', 'poste_id');
    }

    public function permissions()
    {
        return $this->hasMany(' App\Models\Permission');
    }

    public function userconnect()
    {
        return $this->hasOne('App\Models\User');
    }

    public function achives()
    {
        return $this->hasMany(' App\Models\Achive');
    }

    public function notifications()
    {
        return $this->belongsToMany(' App\Models\Notification');
    }

}